package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsPointsGoods;

import java.util.List;

/**
 * 积分商品Service接口
 *
 * @author ruoyi
 * @date 2025-08-28
 */
public interface IBbsPointsGoodsService extends IService<BbsPointsGoods> {

    /**
     * 查询积分商品列表
     *
     * @param bbsPointsGoods 积分商品
     * @return 积分商品集合
     */
    List<BbsPointsGoods> selectBbsPointsGoodsList(BbsPointsGoods bbsPointsGoods);


    /**
     * 添加积分商品
     *
     * @param goods 积分商品
     */
    void addGoods(BbsPointsGoods goods);


    /**
     * 修改积分商品
     *
     * @param goods 积分商品
     */
    void editGoods(BbsPointsGoods goods);


    /**
     * 删除积分商品
     *
     * @param goodsId 积分商品Id
     */
    void deleteGoods(Long goodsId);


    /**
     * 查询积分商品
     *
     * @param goodsCode 商品编码
     * @return 商品
     */
    BbsPointsGoods getByGoodsCode(String goodsCode);


    /**
     * 扣减积分商品库存数量
     *
     * @param goodsId  商品Id
     * @param goodsNum 商品数量
     * @return
     */
    boolean decrGoodsStock(long goodsId, int goodsNum);


    /**
     * 扣减积分商品库存数量
     *
     * @param goodsId 商品Id
     * @param goodsNum 商品数量
     */
    void incrGoodsSales(long goodsId, int goodsNum);

}
