package com.tangguo.framework.activemq;

import com.tangguo.common.constant.ActiveMQConstant;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.command.ActiveMQQueue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.core.JmsTemplate;

import javax.jms.ConnectionFactory;
import javax.jms.Queue;

/**
 * ActiveMQ队列配置
 *
 * @author 谈笑
 * @createTime 2025-09-01 15:53:31 星期一
 */
@EnableJms
@Configuration
public class ActiveMQConfig {

	/**
	 * 增加用户积分队列
	 */
	@Bean
	public Queue incrUserPointsQueue() {
		return new ActiveMQQueue(ActiveMQConstant.Points.INCR_USER_POINTS_QUEUE);
	}


	/**
	 * 扣减用户积分队列
	 */
	@Bean
	public Queue decrUserPointsQueue() {
		return new ActiveMQQueue(ActiveMQConstant.Points.DECR_USER_POINTS_QUEUE);
	}


	/**
	 * 点对点 (队列) 模式
	 */
	@Bean(ActiveMQConstant.QUEUE_CONTAINER_BEAN)
	public JmsListenerContainerFactory<?> queueContainer(ConnectionFactory connectionFactory) {
		DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
		factory.setPubSubDomain(false);
		factory.setSessionAcknowledgeMode(ActiveMQSession.INDIVIDUAL_ACKNOWLEDGE);
		factory.setSessionTransacted(false);
		factory.setConnectionFactory(connectionFactory);
		return factory;
	}

}
